#!/usr/bin/perl

print STDERR "Scanning message and help files and surveys which multibyte chars are used...\n";

while (<>) {
    &entry_kanji($_);
}
    
print STDERR "\n$count unique chars\n";

$fillzero = 0;
$charset = 0;
$jismode = $bigfivemode = 0;

print STDERR "Shrink BDF files by removing unused characters...\n";

while (<STDIN>) {
    if (!$charset && /^CHARSET_REGISTRY "(.*)"$/) {
	$charset = $1;
	if ($charset =~ /JISX0208/i) {
	    print STDERR "BDF font uses JIS charset\n";
	    $jismode = 1;
	}
	elsif ($charset =~ /BIG5/i) {
	    print STDERR "BDF font uses Big-5 charset\n";
	    $bigfivemode = 1;
	}
	elsif ($charset =~ /KSC5601/i) {
	    print STDERR "BDF font uses KSC charset\n";
	    $kscmode = 1;
	}
    }
    if (/^[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]$/) {
	if ($fillzero) {
	    print "0000\n";
	}
	else {
	    print;
	}
    }
    elsif (/^ENCODING (\d+)$/) {
	$encoding = $1;
	if (!$charset) {
	    die "Charset not found\n";
	}
	if ($jismode) {
	    $encoding = &jistoeuc($encoding);
	}
	elsif ($kscmode) {
	    $encoding = &ksctoeuc($encoding);
	}
	if (!$usedkanji{$encoding}) {
	    $fillzero = 1;
	}
	else {
	    printf(STDERR "%04x ", $encoding);
	    $fillzero = 0;
	}
	print;
    }
    else {
	print;
    }
}

sub jistoeuc {
    local($code) = @_;
    local($c1, $c2);
    
    $c2 = $code % 256;
    $c1 = ($code - $c2) / 256;
    $c1 += 128;
    $c2 += 128;
    $c1 * 256 + $c2;
}

sub ksctoeuc {
    local($code) = @_;
    local($c1, $c2);
    
    $c2 = $code % 256;
    $c1 = ($code - $c2) / 256;
    $c1 += 128;
    $c2 += 128;
    $c1 * 256 + $c2;
}

sub entry_kanji
{
    local($line) = @_;
    local($i, $len, $c, $kchar);

    $len = length($line);

    for ($i = 0; $i < $len; $i++) {
	$line =~ s/^(.)//;
	$c = ord($1);
	if ($c >= 0xa0 && $c <= 0xff) {
	    $line =~ s/^(.)//;
	    $kchar = $c * 256 + ord($1);
	    $i++;
	    if (!$usedkanji{$kchar}) {
		$usedkanji{$kchar} = 1;
		printf(STDERR "%04x ", $kchar);
		$count++;
	    }
	}
    }
}
