/*-
 * Copyright (c) 1998 Dag-Erling Codan Smrgrav
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in this position and unchanged.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/modules/syscons/rain/rain_saver.c,v 1.5.2.1 2000/05/10 16:26:47 obrien Exp $
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/module.h>
#include <sys/syslog.h>
#include <sys/consio.h>
#include <sys/fbio.h>
#include <sys/random.h>

#include <dev/fb/fbreg.h>
#include <dev/fb/splashreg.h>
#include <dev/syscons/syscons.h>

static u_char *vid;

static int banksize, scrmode, bpsl, scrw, scrh;

#define MAX 63

static u_char rain_pal[768];
static int blanked;

static void
rain_update(video_adapter_t *adp)
{
    int i, t;

    t = rain_pal[(MAX*3+2)];
    for (i = (MAX*3+2); i > 5; i -= 3)
	rain_pal[i] = rain_pal[i-3];
    rain_pal[5] = t;
    load_palette(adp, rain_pal);
}

static int
rain_saver(video_adapter_t *adp, int blank)
{
    u_char temp;
    int i, j, k, pl;
    int o, p;

    if (blank) {
	/* switch to graphics mode */
	if (blanked <= 0) {
	    pl = splhigh();
	    set_video_mode(adp, scrmode);
	    load_palette(adp, rain_pal);
#if 0 /* XXX conflict */
	    set_border(adp, 0);
#endif
	    blanked++;
	    vid = (u_char *)adp->va_window;
	    banksize = adp->va_window_size;
	    bpsl = adp->va_line_width;
	    splx(pl);
	    for (i = 0; i < bpsl*scrh; i += banksize) {
		set_origin(adp, i);
		if ((bpsl * scrh - i) < banksize)
		    bzero(vid, bpsl * scrh - i);
		else
		    bzero(vid, banksize);
	    }
	    set_origin(adp, 0);
	    for (i = 0, o = 0, p = 0; i < scrw; i += 2, p += 2) {
		if (p > banksize) {
		    p -= banksize;
		    o += banksize;
		    set_origin(adp, o);
		}
		vid[p] = 1 + (random() % MAX);
	    }
	    o = 0; p = 0;
	    for (j = 1; j < scrh; j++)
		for (i = 0, p = bpsl * (j - 1) - o; i < scrw; i += 2, p+= 2) {
		    while (p > banksize) {
			p -= banksize;
			o += banksize;
		    }
		    set_origin(adp, o);
		    temp = (vid[p] < MAX) ? 1 + vid[p] : 1;
		    if (p + bpsl < banksize) {
			vid[p + bpsl] = temp;
		    } else {
			set_origin(adp, o + banksize);
			vid[p + bpsl - banksize] = temp;
		    }
		}
	}

	/* update display */
	rain_update(adp);
	
    } else {
	blanked = 0;
    }
    return 0;
}

static int
rain_init(video_adapter_t *adp)
{
    video_info_t info;
    int i;

    if (!get_mode_info(adp, M_VGA_CG320, &info)) {
	scrmode = M_VGA_CG320;
    } else if (!get_mode_info(adp, M_PC98_PEGC640x480, &info)) {
	scrmode = M_PC98_PEGC640x480;
    } else if (!get_mode_info(adp, M_PC98_PEGC640x400, &info)) {
	scrmode = M_PC98_PEGC640x400;
    } else {
        log(LOG_NOTICE, "logo_saver: no suitable graphics mode\n");
	return ENODEV;
    }

    /* intialize the palette */
    for (i = 3; i < (MAX+1)*3; i += 3)
	rain_pal[i+2] = rain_pal[i-1] + 4;

    scrw = info.vi_width;
    scrh = info.vi_height;
    blanked = 0;

    return 0;
}

static int
rain_term(video_adapter_t *adp)
{
    return 0;
}

static scrn_saver_t rain_module = {
    "rain_saver", rain_init, rain_term, rain_saver, NULL,
};

SAVER_MODULE(rain_saver, rain_module);
