#!/bin/sh
#
if [ "`id -u`" != "0" ]; then
	echo "Sorry, this must be done as root."
	exit 1
fi
if [ $# -lt 1 ]; then
	echo "You must specify which components of 98src to extract"
	echo "possible subcomponents are:"
	echo
	echo "base etc release share sys usbin"
	echo
	echo "You may also specify all to extract all subcomponents."
	exit 1
fi

if [ "$1" = "all" ]; then
	dists="base etc release share sys usbin"
else
	dists="$*"
fi

echo "Extracting 98 sources into ${DESTDIR}/usr/src..."
for i in $dists; do
	echo "  Extracting 98 source component: $i"
	cat s${i}.?? | tar --unlink -xpzf - -C ${DESTDIR}/usr/src
done
echo "Done extracting 98 sources."
exit 0
